<?php
	global $VISUAL_COMPOSER_EXTENSIONS;

	function TS_VCSC_FileGetContentsCurl($url, $retries = 5) {
		$ua 					= 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.82 Safari/537.36';
		if (extension_loaded('curl') === true) {
			$ch = curl_init();	
			curl_setopt($ch, CURLOPT_URL, $url); 				// The URL to fetch. This can also be set when initializing a session with curl_init().
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); 	// TRUE to return the transfer as a string of the return value of curl_exec() instead of outputting it out directly.
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10); 		// The number of seconds to wait while trying to connect.
			curl_setopt($ch, CURLOPT_USERAGENT, $ua); 			// The contents of the "User-Agent: " header to be used in a HTTP request.
			curl_setopt($ch, CURLOPT_FAILONERROR, TRUE); 		// To fail silently if the HTTP code returned is greater than or equal to 400.
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE); 	// To follow any "Location: " header that the server sends as part of the HTTP header.
			curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE); 		// To automatically set the Referer: field in requests where it follows a Location: redirect.
			curl_setopt($ch, CURLOPT_TIMEOUT, 10); 				// The maximum number of seconds to allow cURL functions to execute.
			curl_setopt($ch, CURLOPT_MAXREDIRS, 5); 			// The maximum number of redirects
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); 		// Verify the peer's SSL certificate true/false
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0); 		// Verify the certificate's name against host true/false
			$result = curl_exec($ch);	
			curl_close($ch);
		} else {
			$result				= file_get_contents($url);
		}       
		if (empty($result) === true) {
			$result				= false;	
			if ($retries >= 1) {
				sleep(1);
				return TS_VCSC_FileGetContentsCurl($url, --$retries);
			}
		}
		return $result;
	}
?>
<div id="ts-settings-changelog" class="tab-content">
	<div class="ts-vcsc-section-main">
		<div class="ts-vcsc-section-title ts-vcsc-section-show"><i class="dashicons-media-text"></i>Changelog</div>
		<div class="ts-vcsc-section-content">
			<div class="ts-vcsc-notice-field ts-vcsc-success" style="margin-top: 10px; font-size: 13px; text-align: justify;">
				The plugin is constantly evolving and adding new features. The listing below is a summary of all changes and additions so far.
			</div>	
			<?php
				$url_gets		= ini_get('allow_url_fopen');
				$url_site 		= get_site_url();
				$url_file		= TS_VCSC_GetResourceURL('changelog.txt');
				if (strpos($url_file, $url_site) !== false) {
					$url_final	= $url_file;
				} else {
					$url_final	= $url_site . $url_file;
				}
				if ($url_gets == 1) {
					$changelog 		= TS_VCSC_FileGetContentsCurl($url_final, true);
					echo nl2br(str_replace('<br/>', PHP_EOL, $changelog));
				} else {
					echo 'Your site setup does not allow the usage of "allow_url_fopen" and so the changelog file could not be loaded. You can find the full and official changelog
					<a href="https://helpdesk.krautcoding.com/changelog-composium-visual-composer-extensions/" target="_blank">here</a>.';
				}
			?>
		</div>
	</div>
</div>